﻿using MCSShared;
using Microsoft.Xrm.Sdk;
using System;
using System.Linq;
using VA.TMP.DataModel;
using VA.TMP.OptionSets;

namespace VA.TMP.CRM
{
    public class ParticipatingSiteCreatePreStageRunner : PluginRunner
    {
        public ParticipatingSiteCreatePreStageRunner(IServiceProvider serviceProvider) : base(serviceProvider){}
        /// <summary>
        /// Entry Point for Participating Site Pre Create Plugin Runner
        /// </summary>
        /// <param name="serviceProvider">CRM Service Provider used to Retrieve Org Service, PluginContext, Tracing Service, etc.</param>
        public new void RunPlugin(IServiceProvider serviceProvider) { base.RunPlugin(serviceProvider); }

        /// <summary>
        /// Ensure the name is correct
        /// </summary>
        public override void Execute()
        {
            Logger.WriteDebugMessage("About to retrieve the derived name.");
            //Check Pre Name against format and update if needed
            var derivedName = CvtHelper.ReturnRecordNameIfChanged(PrimaryEntity.ToEntity<cvt_participatingsite>(), true, Logger, OrganizationService);
            Logger.WriteDebugMessage("The derivedName came back, it is: " + derivedName.ToString());

            if (!String.IsNullOrEmpty(derivedName))
            {
                Logger.WriteDebugMessage(String.Format("The Participating Site name should be different than {0}, updating it in the CreatePreStage to: {1}.", PrimaryEntity.Attributes["cvt_name"].ToString(), derivedName));
                PrimaryEntity.Attributes["cvt_name"] = (string)derivedName;
                Logger.WriteDebugMessage("New name as read from the PrimaryEntity: " + PrimaryEntity.Attributes["cvt_name"].ToString());
            }
            else
            {
                Logger.WriteDebugMessage("No change made to the name.  The Participating Site name is already correct.");
            }

            Boolean isHMPat = CheckHMPat(PrimaryEntity.ToEntity<cvt_participatingsite>());
            if (isHMPat)
                throw new InvalidPluginExecutionException("Cannot create a Patient Participating Site.  Only Provider Sites can be added to a VA Video Connect Resource Package.");


            //Check to see if this PS already exists for this SP
            Boolean isDuplicate = CheckDuplicate(PrimaryEntity.ToEntity<cvt_participatingsite>());
            if (isDuplicate)
                throw new InvalidPluginExecutionException("This Site has already been added in this location type on this Scheduling Package. Please make edits to the existing Participating Site.");

            Logger.WriteDebugMessage("End of PreStageCreate Execute method.");
        }     
        
        internal Boolean CheckHMPat(cvt_participatingsite thisRecord){
            Boolean eval = false;
            if (thisRecord.Contains("cvt_locationtype") && thisRecord.cvt_locationtype != null)
            {
                if (thisRecord.cvt_locationtype.Value == (int)cvt_participatingsitecvt_locationtype.Patient) //Patient
                {
                    //Query Scheduling Package to see if it is H/M
                    using (var srv = new Xrm(OrganizationService))
                    {
                        var parentSchedulingPackage = srv.cvt_resourcepackageSet.FirstOrDefault(sp => sp.Id == thisRecord.cvt_resourcepackage.Id);
                        if (parentSchedulingPackage != null && parentSchedulingPackage.cvt_patientlocationtype != null)
                        {
                            if (parentSchedulingPackage.cvt_patientlocationtype.Value == (int)cvt_resourcepackagecvt_patientlocationtype.HomeMobile)
                                eval = true;
                        }
                    }
                }
            }
            return eval;
        }

        internal Boolean CheckDuplicate(cvt_participatingsite thisRecord)
        {
            Boolean eval = false;

            using (var srv = new Xrm(OrganizationService))
            {
                var duplicatePS = srv.cvt_participatingsiteSet.FirstOrDefault(ps => ps.cvt_resourcepackage.Id == thisRecord.cvt_resourcepackage.Id && ps.cvt_site.Id == thisRecord.cvt_site.Id && ps.cvt_locationtype == thisRecord.cvt_locationtype);
                if (duplicatePS != null)
                    eval = true;
            }
            return eval;
        }

        #region Additional Interface Methods/Properties
        /// <summary>
        /// Used for Debugging - turns on or off creation of log records for this particular entity
        /// </summary>
        public override string McsSettingsDebugField
        {
            get { return "cvt_ppereview"; }
        }
        #endregion
    }
}